/*
 * Decompiled with CFR 0.152.
 */
package ui;

import application.ArchiveService;
import java.util.Scanner;

public class CLI {
    private ArchiveService as = new ArchiveService();
    private Scanner in = new Scanner(System.in);

    public void run() {
        System.out.println("#######################################");
        System.out.println("Welcome to my password manager system !");
        System.out.println("To Start you need to load with the correct key, HF");
        System.out.print("Enter the key : ");
        String answer = this.in.next();
        this.as.loadArchive(answer);
        while (true) {
            int index;
            System.out.print("Waiting for a number ... (-1 for help) ");
            answer = this.in.next();
            try {
                index = Integer.parseInt(answer);
            }
            catch (Exception e) {
                System.out.println("This is not a correct number");
                index = -1;
            }
            switch (index) {
                case 1: {
                    this.reloadArchive();
                    break;
                }
                case 2: {
                    this.research();
                    break;
                }
                case 3: {
                    this.removeLine();
                    break;
                }
                case 4: {
                    this.addLine();
                    break;
                }
                case 5: {
                    this.changeCryptageOfArchive();
                    break;
                }
                case 6: {
                    this.as.printArchive();
                    break;
                }
                case 7: {
                    System.out.println("Not implemented yet");
                    break;
                }
                case 8: {
                    System.out.println("Not implemented yet");
                    break;
                }
                case 9: {
                    System.out.println("Not implemented yet");
                    break;
                }
                case -1: {
                    this.printHelp();
                    break;
                }
                case 0: {
                    System.out.println("Bye bye !");
                    System.out.println("#######################################");
                    return;
                }
                default: {
                    this.printHelp();
                }
            }
            System.out.println("###################################");
        }
    }

    private void changeCryptageOfArchive() {
        System.out.print("Enter the new key : ");
        String answer = this.in.next();
        this.as.changeCryptage(answer);
        System.out.println("Remember your new key is : '" + answer + "' you will need it lately");
    }

    private void removeLine() {
        System.out.print("Enter the ID of the line you want to delete : ");
        String answer = this.in.next();
        try {
            int index = Integer.parseInt(answer);
            this.as.removeLine(index);
        }
        catch (NumberFormatException e) {
            System.out.println("This is not a correct ID");
        }
    }

    private void research() {
        System.out.print("Enter your research : ");
        String researchName = this.in.next();
        this.as.printLine(researchName);
    }

    private void reloadArchive() {
        System.out.print("Enter the new key of the archive : ");
        String newKey = this.in.next();
        if (newKey.equals("-1")) {
            return;
        }
        this.as.loadArchive(newKey);
    }

    private void addLine() {
        String newLine = "##";
        System.out.print("Enter the name of the new line : ");
        String lineName = this.in.next();
        if (lineName.equals("-1")) {
            return;
        }
        newLine = newLine + lineName;
        newLine = newLine + " : { ";
        boolean stop = false;
        while (!stop) {
            System.out.println("Enter '-1' at any moment to stop");
            System.out.print("Enter the name of the content : ");
            String contentName = this.in.next();
            if (contentName.equals("-1")) {
                stop = true;
                break;
            }
            System.out.print("Enter the content : ");
            String content = this.in.next();
            if (content.equals("-1")) {
                stop = true;
                break;
            }
            newLine = newLine + contentName + " : " + content + ",";
        }
        newLine = newLine + " }\n";
        this.as.addLine(newLine);
    }

    private void printHelp() {
        System.out.println("------------ HELP ------------");
        System.out.println("    - '1' to reload your archive with a new key");
        System.out.println("    - '2' to research in your archive lines corresponding to a string");
        System.out.println("    - '3' to remove a line with its ID");
        System.out.println("    - '4' to add a new line");
        System.out.println("    - '5' to change your key");
        System.out.println("    - '6' to print all the archive");
        System.out.println("    - '-1' to ask for help");
        System.out.println("    - '0' to exit");
    }
}

