/*
 * Decompiled with CFR 0.152.
 */
package infra;

import domain.Cryptage;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class CipherCryptage
implements Cryptage {
    public static final String UNICODE_FORMAT = "UTF-8";
    private static final String encryptionType = "AES";
    private Cipher cipher;
    private String secretKey;

    public CipherCryptage(String key) {
        try {
            this.secretKey = key;
            this.cipher = Cipher.getInstance(encryptionType);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public String encrypt(String input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            SecretKeySpec key = new SecretKeySpec(messageDigest.digest(this.secretKey.getBytes(UNICODE_FORMAT)), encryptionType);
            this.cipher.init(1, key);
            byte[] encrypted = this.cipher.doFinal(input.getBytes(UNICODE_FORMAT));
            byte[] encoded = Base64.getEncoder().encode(encrypted);
            return new String(encoded, UNICODE_FORMAT);
        }
        catch (Exception e) {
            System.out.println("Cannot encrypt, your key must be wrong !");
            return null;
        }
    }

    @Override
    public String decrypt(String input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            SecretKeySpec key = new SecretKeySpec(messageDigest.digest(this.secretKey.getBytes(UNICODE_FORMAT)), encryptionType);
            Cipher cipher = Cipher.getInstance(encryptionType);
            cipher.init(2, key);
            byte[] decoded = Base64.getDecoder().decode(input.getBytes(UNICODE_FORMAT));
            byte[] decrypted = cipher.doFinal(decoded);
            return new String(decrypted, UNICODE_FORMAT);
        }
        catch (Exception e) {
            System.out.println("Cannot decrypt, your key must be wrong !");
            return null;
        }
    }

    @Override
    public void changeKey(String newKey) {
        this.secretKey = newKey;
    }
}

