/*
 * Decompiled with CFR 0.152.
 */
package infra;

import domain.Archive;
import domain.ArchiveRepository;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ArchiveRepositoryInFile
implements ArchiveRepository {
    private String path = "data/mdp.mine_encrypt";

    @Override
    public void saveArchive(Archive archive) {
        System.out.println("Saving archive ...");
        try (FileWriter newFile = new FileWriter(this.path);){
            for (int i = 0; i < archive.numberOfLine(); ++i) {
                newFile.write(archive.fileFormatLine(i) + "\n");
            }
        }
        catch (IOException e) {
            System.err.println("Error while writing");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Archive loadArchive(String key) {
        System.out.println("Loading archive ...");
        Archive archive = new Archive(key);
        try (BufferedReader bufferReader = new BufferedReader(new FileReader(this.path));){
            String line;
            while ((line = bufferReader.readLine()) != null) {
                if (line.length() <= 2 || archive.loadLine(line)) continue;
                Archive archive2 = null;
                return archive2;
            }
            bufferReader.close();
            return archive;
        }
        catch (FileNotFoundException e) {
            System.out.println("File does not exist");
            return null;
        }
        catch (IOException e) {
            System.out.println("Error while reading");
            return null;
        }
    }
}

