/*
 * Decompiled with CFR 0.152.
 */
package domain;

import domain.Content;
import domain.Cryptage;
import domain.Line;
import infra.CipherCryptage;
import java.util.ArrayList;

public class Archive {
    private ArrayList<Line> lines = new ArrayList();
    private Cryptage cryptage;
    private int nbLines = 0;

    public Archive(String key) {
        this.cryptage = new CipherCryptage(key);
    }

    public boolean loadLine(String line) {
        String decrypt = this.cryptage.decrypt(line);
        try {
            this.lines.add(new Line(++this.nbLines, decrypt));
            return true;
        }
        catch (Exception e) {
            System.out.println("\"" + line + "\" => \"" + decrypt + "\"  : is not conform to archive format");
            System.out.println("Your key must be wrong !");
            return false;
        }
    }

    public void addLine(String line) {
        try {
            this.lines.add(new Line(++this.nbLines, line));
            System.out.println("Line of ID " + this.nbLines + " added");
        }
        catch (Exception e) {
            System.out.println(line + " is not conform to archive format");
            System.out.println("Your key must be wrong !");
        }
    }

    public void removeLine(int idLine) {
        Line lineToDelete = null;
        for (Line line : this.lines) {
            if (line.getId() != idLine) continue;
            lineToDelete = line;
        }
        if (lineToDelete != null) {
            this.lines.remove(lineToDelete);
            System.out.println("Line of ID " + idLine + " removed");
        } else {
            System.out.println("There is no line of this ID");
        }
    }

    public void replaceLine(int idLine, String newLine) {
        Line lineToUpdate = null;
        for (Line line : this.lines) {
            if (line.getId() != idLine) continue;
            lineToUpdate = line;
        }
        if (lineToUpdate != null) {
            try {
                this.lines.add(new Line(lineToUpdate.getId(), newLine));
                this.lines.remove(lineToUpdate);
                System.out.println("Line of ID " + idLine + " replaced");
            }
            catch (Exception e) {
                System.out.println(newLine + " is not conform to archive format");
                System.out.println("Your key must be wrong !");
            }
        } else {
            System.out.println("There is no line of this ID");
        }
    }

    public void printLine(String name) {
        name = name.toUpperCase();
        System.out.println("Lines corresponding to : " + name);
        System.out.println("/*");
        for (Line line : this.lines) {
            if (!line.getName().contains(name)) continue;
            System.out.println("    - " + line);
        }
        System.out.println("*/");
    }

    public int numberOfLine() {
        return this.lines.size();
    }

    public void changeCryptage(String key) {
        this.cryptage.changeKey(key);
    }

    public String fileFormatLine(int index) {
        Line line = this.lines.get(index);
        Content content = line.getContent();
        String fileString = "##" + line.getName() + " : ";
        fileString = fileString + content.fileFormatString();
        return this.cryptage.encrypt(fileString);
    }

    public String toString() {
        String res = "Archive : ";
        for (Line line : this.lines) {
            res = res + line + "\n";
        }
        return res;
    }
}

