/*
 * Decompiled with CFR 0.152.
 */
package application;

import domain.Archive;
import domain.ArchiveRepository;
import infra.ArchiveRepositoryInFile;

public class ArchiveService {
    private ArchiveRepository repository = new ArchiveRepositoryInFile();
    private Archive cache = null;

    public void loadArchive(String key) {
        this.cache = this.repository.loadArchive(key);
        if (this.cache != null) {
            System.out.println("Archive loaded with key = " + key);
        } else {
            System.out.println("Archive failed to load with key = " + key);
        }
        System.out.println("------------------------------------------------");
    }

    public void changeCryptage(String newKey) {
        if (this.cache == null) {
            System.out.println("You need to correctly load the archive first");
            return;
        }
        System.out.println("###########################################");
        this.cache.changeCryptage(newKey);
        this.repository.saveArchive(this.cache);
        System.out.println("###########################################");
    }

    public void addLine(String line) {
        if (this.cache == null) {
            System.out.println("You need to correctly load the archive first");
            return;
        }
        System.out.println("###########################################");
        this.cache.addLine(line);
        this.repository.saveArchive(this.cache);
        System.out.println("###########################################");
    }

    public void replaceLine(int lineId, String line) {
        if (this.cache == null) {
            System.out.println("You need to correctly load the archive first");
            return;
        }
        System.out.println("###########################################");
        this.cache.replaceLine(lineId, line);
        this.repository.saveArchive(this.cache);
        System.out.println("###########################################");
    }

    public void removeLine(int lineId) {
        if (this.cache == null) {
            System.out.println("You need to correctly load the archive first");
            return;
        }
        System.out.println("###########################################");
        this.cache.removeLine(lineId);
        this.repository.saveArchive(this.cache);
        System.out.println("###########################################");
    }

    public void printLine(String name) {
        if (this.cache == null) {
            System.out.println("You need to correctly load the archive first");
            return;
        }
        System.out.println("###########################################");
        this.cache.printLine(name);
        System.out.println("###########################################");
    }

    public void printArchive() {
        if (this.cache == null) {
            System.out.println("You need to correctly load the archive first");
            return;
        }
        System.out.println(this.cache);
    }
}

